% ALPHA ENGINE DEFINITION
% Generated 08-Aug-2018 13:15:19

% SUGGESTED CITATION:
% 2014 Chevrolet 4.3L EcoTec3 LV3 Engine Tier 2 Fuel - ALPHA Map Package. Version 2018-08. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2018.


% Constructor
engine = class_REVS_engine();
engine.name =  '2014 Chevrolet 4.3L EcoTec3 LV3 Engine Tier 2 Fuel'; 
engine.source_filename = mfilename;engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  4.3; 
engine.num_cylinders =  6; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.bore_mm =  99.6; 
engine.stroke_mm =  92; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	    0.00000000000000000	;     83.775804095727807	;     104.71975511965977	;     167.55160819145561	;     209.43951023931953	;     251.32741228718345	;     335.10321638291123	;     376.99111843077515	;     408.40704496667308	;     460.76692252650298	;     534.07075111026484	;     575.95865315812875	;     604.75658581603523	;     633.55451847394170		]; 
engine.full_throttle_torque_Nm = [	    0.00000000000000000	;     271.16359999999997	;     305.05905000000001	;     328.10795600000000	;     359.29176999999999	;     379.62903999999997	;     386.40812999999997	;     406.74540000000002	;     413.52449000000001	;     406.74540000000002	;     393.18721999999997	;     366.07085999999998	;     313.77502285714286	;    0.00000000000000000		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	    0.00000000000000000	;     83.671084340608147	;     104.71975511965977	;     366.41442316368955	;     633.55451847394170		]; 
engine.closed_throttle_torque_Nm = [	    -31.671259259259259	;    -38.299999999999997	;    -41.200000000000003	;    -60.700000000000003	;    -81.863851851851877		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	    0.00000000000000000	;     30.768908048908607	;     61.537816097817213	;     83.775804095727807	;     104.06839824281546	;     115.75157855322699	;     131.11541659512119	;     144.93214108560912	;     157.01231283691277	;     182.51017071182952	;     209.42642026992959	;     261.78090784236360	;     314.10690548141946	;     366.41442316368955	;     418.78178070602792	;     471.23889803846896	;     523.59877559829886	;     578.57664703612022	;     633.55451847394170		]; 
engine.fuel_map_torque_Nm = [	    -85.155000000000030	;    -64.602500000000020	;    -44.049999999999997	;    -27.071249999999999	;    -10.369034090909091	;     6.3331818181818180	;     19.656666666666666	;     32.707884615384614	;     51.486666666666665	;     58.200000000000003	;     63.189999999999998	;     71.528214285714284	;     86.925833333333344	;     99.700000000000003	;     105.44000000000000	;     117.28900000000000	;     131.69999999999999	;     142.77875000000000	;     166.37500000000000	;     187.68093750000000	;     208.98687500000000	;     228.09999999999999	;     247.95071428571430	;     267.80142857142857	;     286.63999999999999	;     298.60000000000002	;     318.45555555555552	;     341.33571428571429	;     361.94999999999999	;     398.07535725000002	;     434.20071450000006		]; 
engine.fuel_map_gps = [
   0.16455690592263483	   0.12751418942500417	  0.088033027895904128	  0.054878617092249005	  0.019954795695074488	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	;
   0.13441924068900232	   0.11941847387338005	   0.10752626260706893	   0.10296177813509530	   0.10094562434251282	  0.099478021375625267	  0.096111047610412406	  0.089567057926239313	  0.080386677448412755	  0.044137181984923987	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	  0.070275589091640278	   0.21115898628161617	   0.30693976600037454	   0.34391952264421149	   0.34848901030775659	   0.34219473548745621	;
   0.11046448643807819	   0.12080086293965428	   0.13314028172034220	   0.14779517405102890	   0.17001483181510785	   0.18910975470153663	   0.21623438060495773	   0.23718699111198374	   0.25021474860845933	   0.23635936748217426	   0.19513639514341682	   0.17463067075855365	   0.36226934894797647	   0.55075959951962228	   0.76248491570651433	   0.87230624425871084	   0.92797470216986044	   0.97910518304727390	    1.0338340203886327	;
  0.093763114921711202	   0.13272969964108328	   0.17210616133333656	   0.20466638098475545	   0.23941618283970953	   0.26154160868473098	   0.29110605054624500	   0.31569043266493901	   0.33463190082097821	   0.36175901225592960	   0.37738807571180683	   0.44062195135094973	   0.65750490718024479	   0.92511673110303727	    1.2018104205876616	    1.3120681712340332	    1.3986890732234871	    1.5029581434724397	    1.6168297016660127	;
  0.076725033872724405	   0.14814934653695816	   0.21588624859696270	   0.26093477846461044	   0.30290446206516758	   0.32820652116175869	   0.36266777462673894	   0.39461080461580339	   0.42289223577359081	   0.48320306745200864	   0.54694169988201735	   0.68940158519216310	   0.93694214546768795	    1.2607007657547331	    1.5860268415317247	    1.7114298348450148	    1.8541806301106025	    2.0239810501441977	    2.2035454219238808	;
  0.055678643975758613	   0.15493927985176031	   0.25188671929129303	   0.30782732879191910	   0.36086665388248279	   0.39347958986439258	   0.43875690117098054	   0.48230443414501528	   0.52228221818508835	   0.61406029975422383	   0.71816974832858960	   0.91481750977062759	    1.1959557148903812	    1.5673500274727232	    1.8471506482860374	    2.0809915205888929	    2.3091113618353658	    2.5544814815157011	    2.8060972807896385	;
  0.036737204513035991	   0.14683341087197016	   0.25467131844028196	   0.33378319626705688	   0.40978535580826009	   0.45305814232956854	   0.50939457955456913	   0.56118727561846393	   0.60862398376389337	   0.72493484359971005	   0.86211699151747956	    1.0813412894935019	    1.3871719960484457	    1.8060729911663982	    2.0446123091727393	    2.3768418630698034	    2.6769015925560025	    2.9861717859175543	    3.2981094970404294	;
  0.017809661923690712	   0.14034612956362369	   0.26132370104520541	   0.35790574098662775	   0.46744957405789811	   0.52449178792949036	   0.59374914088260511	   0.65032977097958800	   0.70120607899327114	   0.83880702373271909	    1.0009912696731278	    1.2400440599772569	    1.5711636017394095	    2.0314392102556362	    2.3036734688759415	    2.6812049073412654	    3.0445734158817639	    3.4171833521412438	    3.7890749584036563	;
   0.00000000000000000	   0.15258147760141724	   0.31393595741981678	   0.43958976128851956	   0.56691056274570206	   0.63634291273700228	   0.72552997960191790	   0.80457592088586305	   0.87375718391987633	    1.0227062699678060	    1.1822496901023791	    1.4857799450766207	    1.8798445823584715	    2.3932340258797282	    2.7473740947110068	    3.1620818370953789	    3.5987058868338990	    4.0589159546870324	    4.5150250861611863	;
   0.00000000000000000	   0.16214159546846477	   0.33901708406682857	   0.47293972431868436	   0.60034621436176072	   0.67389311705286647	   0.77075348001091493	   0.85796477136524696	   0.93378663161326536	    1.0889308195593581	    1.2508794413568272	    1.5861221563361452	    1.9955822516731410	    2.5404792019522149	    2.9145477412986081	    3.3436738652870983	    3.8056703361077751	    4.2949918398418099	    4.7792596406799497	;
   0.00000000000000000	   0.16990095980233583	   0.35813835456585669	   0.49776704733334759	   0.62551312950841531	   0.70171949866985184	   0.80385688782766251	   0.89704434282431489	   0.97801486115334291	    1.1379980358453721	    1.3026324121540644	    1.6635229009910451	    2.0822214455665384	    2.6522801582482778	    3.0399709076382457	    3.4801269088112718	    3.9610377388043148	    4.4715894693572444	    4.9764219966095427	;
   0.00000000000000000	   0.18391412782291611	   0.39033266578939191	   0.53912022139726856	   0.66873612554153283	   0.74850751474533772	   0.85811479000925772	   0.96073213556030035	    1.0498005499096608	    1.2193820951771408	    1.3911213055290990	    1.8002774586813153	    2.2291027002367660	    2.8418019265151915	    3.2503195509279350	    3.7113010103487896	    4.2241340192397079	    4.7692067330982617	    5.3075639001448733	;
   0.00000000000000000	   0.21240782941679870	   0.44624831561685463	   0.60938797163788139	   0.75196010568866767	   0.83931699730948117	   0.95869528686637939	    1.0727080709506871	    1.1721808680183887	    1.3661726000061509	    1.5673063753879846	    2.1058585191835664	    2.5335018794364652	    3.1753715519497705	    3.6336021710041995	    4.1571727997356698	    4.7311066498009922	    5.3340425100863165	    5.9295205335028820	;
   0.00000000000000000	   0.23493110686897653	   0.49031072397494291	   0.67035879409040566	   0.83361735906456647	   0.92987957303120017	    1.0590775362843503	    1.1775021611488510	    1.2804922113553634	    1.4919318816814744	    1.7218909995579637	    2.3377065947457449	    2.8032516369530915	    3.4404781093259986	    3.9438331460650669	    4.5533863524670730	    5.1756755666439638	    5.8203364710436514	    6.4593516773732613	;
   0.00000000000000000	   0.24477345730900238	   0.51027314902912457	   0.69873686287625991	   0.86903847580606886	   0.96931300348110738	    1.1040443020895774	    1.2272819541699702	    1.3342141649791104	    1.5495467987085869	    1.7848200098021110	    2.4399333891980097	    2.9193249320399208	    3.5608201379045852	    4.0883594280338951	    4.7375973001600027	    5.3795023501766712	    6.0421307991717752	    6.7004411723608719	;
   0.00000000000000000	   0.26468837294312708	   0.55136882138432930	   0.75718225807517048	   0.93858801724209540	    1.0464746352783887	    1.1933394069842662	    1.3325252602035380	    1.4528034877866476	    1.6693246743028809	    1.9012731241795320	    2.6423681144452189	    3.1455349783832731	    3.8147663897396575	    4.4047492362161460	    5.1296436849875837	    5.8071132986478169	    6.5059465523098163	    7.2040465983985582	;
   0.00000000000000000	   0.28893936729082376	   0.59652460579851219	   0.81648256101225536	    1.0150980984247482	    1.1347481529279624	    1.2964577792069643	    1.4463190633658305	    1.5746104654208382	    1.8063136091803487	    2.0467342291569608	    2.8172176824564610	    3.3936695542531679	    4.1312445964801094	    4.9040411565370681	    5.6338696560687147	    6.3412453201123933	    7.0855607637634241	    7.8345491022181486	;
   0.00000000000000000	   0.30906811583453259	   0.63209757053363069	   0.86418687448918141	    1.0786972319773960	    1.2054899803591603	    1.3741397463813485	    1.5255519896656045	    1.6550274991559435	    1.9107764790569746	    2.1765424176567838	    2.9182586643048625	    3.5667447050396284	    4.3557273334180096	    5.3058828518532444	    6.0279757635987981	    6.7591504352842486	    7.5422186290365056	    8.3340369512223109	;
 0.0038696380764395035	   0.36365892408081940	   0.72482019433509426	   0.98674299480947292	    1.2242134327247089	    1.3587174927014254	    1.5385073627976205	    1.7103301381703451	    1.8616457523104266	    2.1626767434555423	    2.4658433588208530	    3.1315402660816951	    3.8785842717367860	    4.7354139826617612	    5.9835389036655133	    6.8523993377717467	    7.6717847256833194	    8.5587946854444379	    9.4608576657831804	;
  0.062646442546485562	   0.44168376578593388	   0.82143461166248499	    1.0976122589768413	    1.3520982442742555	    1.5000639735696806	    1.6975774242730237	    1.8801311146784148	    2.0433551078569678	    2.4030682894936857	    2.7974981212205865	    3.4302005911876741	    4.2014130887636876	    5.0950967816513266	    6.4238146120231194	    7.5446277902728971	    8.5142730228044474	    9.5448281039625336	    10.585855601218965	;
   0.17205057505532703	   0.55766116560858381	   0.94670986874085561	    1.2307657872405795	    1.4931939396415905	    1.6469202112145911	    1.8529019908886746	    2.0446513315789718	    2.2157642881377613	    2.5907794748918680	    2.9897945549678910	    3.7467275705978373	    4.6147716589255108	    5.5485465207991860	    6.9836833640821849	    8.2565281154317294	    9.3894221663204256	    10.594110825138252	    11.813301011379325	;
   0.32077802309275205	   0.69789254700952774	    1.0866995919795561	    1.3786306222008287	    1.6458038797268406	    1.8038024003288640	    2.0168571480528166	    2.2151867692977483	    2.3925970487957322	    2.7818449395334235	    3.2083110172556482	    4.0679815848461942	    5.0238432039374690	    6.2026015779243746	    7.6052844001658215	    8.9367586314381295	    10.213389672045551	    11.589812165045586	    12.999188969046866	;
   0.52544582598988721	   0.88638071549776198	    1.2527626755676307	    1.5343607461626632	    1.8156851090968329	    1.9779447508492449	    2.1949837848306548	    2.3973597891102836	    2.5798682474295305	    2.9873542490611165	    3.4512607564207531	    4.3739568871851837	    5.3749477498521587	    6.8857695582330276	    8.3051503089380354	    9.6753171471150150	    11.099911656422274	    12.681994151057086	    14.311550964434202	;
   0.75792068690344494	    1.1345383427412485	    1.5076236991909424	    1.7774110616813728	    2.0292480562364670	    2.1766520165387511	    2.3788998817154630	    2.5771568106721032	    2.7587558584395202	    3.1656720482308351	    3.6363813310830109	    4.5465238211279697	    5.5743981092650978	    7.3192464663809957	    8.9216042294725568	    10.421670550513660	    12.034427585756671	    13.846524420951267	    15.699378991494543	;
   0.97085918013858996	    1.3968741700427940	    1.8150867796965817	    2.1014016746846353	    2.3438525750543091	    2.4771298608750745	    2.6498768255809044	    2.8186810705541934	    2.9701283910305545	    3.3629014672481325	    3.8241009271197228	    4.7775183318489054	    5.7990834239668878	    7.5580861760661087	    9.4009240937888539	    11.134584375311803	    12.992480319761908	    15.028627030429144	    17.067689686639685	;
    1.0931364103701897	    1.5583632526325815	    2.0154851669376734	    2.3332190658305798	    2.6114033645918608	    2.7643569238427061	    2.9523500321665268	    3.0908996013875316	    3.2092824796563861	    3.5307375911038008	    3.9899432786123867	    4.9737862948148859	    6.0283183491640582	    7.8094389811256306	    9.7678178423833231	    11.608692890508769	    13.645569632335739	    15.811341250447128	    17.947564200802262	;
    1.2688828472884757	    1.8117332415635230	    2.3502730163289032	    2.7315896578603978	    3.0699209230833198	    3.2591976919936134	    3.5015360996252398	    3.7110144343868163	    3.8890106307277610	    4.2349146572438494	    4.6024077365562635	    5.4912426311862523	    6.7201201786209666	    8.5322350158043943	    10.569751726388160	    12.485362555552353	    14.829687010447264	    17.162305209160770	    19.417243607578623	;
    1.4235050467026182	    2.0749186035118061	    2.7261934972551169	    3.1970963976018671	    3.6277496370095150	    3.8766787704140420	    4.2056049648705471	    4.5042493517085731	    4.7681045672590843	    5.3400277726932153	    5.9802475682285614	    7.1624937538102973	    9.3519765667596531	    10.209505743866833	    11.997817088953052	    14.032916533082757	    16.427742997184094	    18.781645549982223	    21.100455839276638	;
    1.5412101360508643	    2.3065840702250497	    3.0766559367300688	    3.6414543602338743	    4.1654214076196272	    4.4711937391385330	    4.8778171749136945	    5.2489146594667178	    5.5772856782136113	    6.2873257793690183	    7.0644570636402673	    8.6654616860615032	    10.500872141587452	    11.526885486058701	    13.523999149621261	    15.555886451749544	    17.888163103812627	    20.244868703195998	    22.600359024976413	;
    1.7462836554630516	    2.7482783288369541	    3.7556445664528306	    4.4909073980904237	    5.1678611126461691	    5.5599493919203820	    6.0778456355885933	    6.5458959978291436	    6.9565206171823988	    7.8282286108912702	    8.7512958921055279	    10.518703982470957	    12.095903639660625	    13.636545598096838	    15.753507310525851	    18.018439808467932	    20.328289438394240	    22.758480045262576	    25.189911258634137	;
    2.0153900778160012	    3.2513288141931262	    4.4846218956809851	    5.3717779786649693	    6.1772097626933675	    6.6390090083669779	    7.2441660084469950	    7.7857331833791656	    8.2571880276435810	    9.2426388667272814	    10.262321441560736	    12.163481145051406	    14.012937254294657	    15.975578615397934	    18.107852640465179	    20.385778456926293	    22.731631527105812	    25.234159823809449	    27.749364296150834	]; 
engine.deac_fuel_map_gps = [
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	   0.52393589569806442	   0.70612622027517080	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	   0.43838768288795904	   0.47651966441801058	   0.51075575034816068	   0.59247232875439093	   0.69968346141052307	   0.89409457883460497	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.37894140807032989	   0.44694198029791843	   0.52215702702763456	   0.58334506712359557	   0.63404844695315565	   0.74453822170793371	   0.86983986064205854	    1.0733762792203334	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.49631681747573048	   0.56706186743107934	   0.65631561622708257	   0.73422012806477044	   0.80111645646742669	   0.93774985538032518	    1.0765539306367613	    1.3458653075373390	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.53590714868367650	   0.60697049322487573	   0.69978103886322418	   0.78338275809780999	   0.85582598269394783	    1.0007977103863206	    1.1429862026442619	    1.4465722901901470	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.56547882576023067	   0.63709515849053999	   0.73150775115656097	   0.81906726397322893	   0.89557031479803983	    1.0468711323454951	    1.1913960784844522	    1.5222661593664020	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.61614504824208882	   0.68885547888561360	   0.78455037309302988	   0.87716205896231569	   0.95858343963233394	    1.1219207979625614	    1.2714843403997298	    1.6507597166718000	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.72031453019891478	   0.79232432449301193	   0.88434867330097955	   0.98427009363165807	    1.0745900641137942	    1.2608329270684313	    1.4361204615260168	    1.8966928539317724	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.80449624541882192	   0.88355922005489829	   0.99090054151874363	    1.0946187728082648	    1.1879804636268390	    1.3890824820394012	    1.5999773196900502	    2.1051914943721823	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.83639660853259490	   0.92074524435460281	    1.0357737034447874	    1.1455749932302148	    1.2438316700610472	    1.4507123640333863	    1.6676912829155628	    2.1985454702877036	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.89868412447015511	   0.99215381037411454	    1.1225425818929251	    1.2518685561700651	    1.3660520967441214	    1.5840166177899411	    1.7929541712558346	    2.3823828347992380	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	    1.0027052791652340	    1.1072450631803543	    1.2494298933701666	    1.3843779746281730	    1.5023397626675770	    1.7341426186641664	    1.9531281366335418	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	    1.0786972319773960	    1.2054899803591603	    1.3550216382938565	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('FTAG 24693');

% Idle Speed
engine.idle_speed_radps = class_REVS_dynamic_lookup;
engine.idle_speed_radps.axis_1.signal =  'veh_spd_mps'; 
engine.idle_speed_radps.axis_1.breakpoints = [	    0.00000000000000000	    1.0000000000000000	    5.0000000000000000	    100.00000000000000		]; 
engine.idle_speed_radps.table = [	     58.643062867009469	    62.831853071795862	    63.879050622992459	    63.879050622992459		]; 

% Pedal Calibration
engine.pedal_map_type = enum_engine_pedal_map_type.max_engine_power;

% Calibration Adjustment Factors
engine.deac_transition_on_duration_secs =  1; 
engine.deac_transition_off_duration_secs =  0.1; 
engine.deac_transition_off_fuel_multiplier = [	     1.8000000000000000	    1.0000000000000000		]; 
engine.deac_transition_off_fuel_multiplier_time_secs = [	    0.00000000000000000	    2.0000000000000000		]; 
engine.DFCO_min_duration_secs =  2; 
engine.DFCO_refuel_multiplier = [	     1.0000000000000000	    2.0000000000000000	    1.0000000000000000		]; 
engine.DFCO_refuel_multiplier_time_secs = [	    0.00000000000000000	   0.10000000000000001	    2.0000000000000000		]; 
